/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.LoggingOutputStream;
import fitnesse.util.MockSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.FileUtil;

public class SlimPipeSocket
extends ServerSocket {
    public static final String STDOUT_PREFIX = "SOUT";
    public static final String STDERR_PREFIX = "SERR";
    public static final String FIRST_LINE_PREFIX = ".:";
    public static final String FOLLOWING_LINE_PREFIX = " :";
    private static final Logger LOG;
    private PrintStream stdout = System.out;
    private PrintStream stderr = System.err;
    private InputStream stdin = System.in;

    public SlimPipeSocket() throws IOException {
        System.setOut(new PrintStream((OutputStream)new LoggingOutputStream(this.stderr, STDOUT_PREFIX), true, FileUtil.CHARENCODING));
        System.setErr(new PrintStream((OutputStream)new LoggingOutputStream(this.stderr, STDERR_PREFIX), true, FileUtil.CHARENCODING));
        LOG.log(Level.FINER, "Creating Slim Server with pipe socket.");
    }

    @Override
    public int getLocalPort() {
        return 1;
    }

    @Override
    public void close() {
        FileUtil.close(this.stdin);
        System.out.flush();
        System.err.flush();
        this.stdout.flush();
        FileUtil.close(this.stdout);
        FileUtil.close(this.stderr);
    }

    @Override
    public Socket accept() {
        return new MockSocket(this.stdin, this.stdout);
    }

    static {
        if (FIRST_LINE_PREFIX.length() != FOLLOWING_LINE_PREFIX.length()) {
            System.err.println("FIRST_LINE_PREFIX and FOLLOWING_LINE_PREFIX must have the same length!!");
            System.exit(-99);
        }
        LOG = Logger.getLogger(SlimPipeSocket.class.getName());
    }
}

