/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.converters.ConverterRegistry;
import fitnesse.slim.converters.GenericCollectionConverter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class SlimExpressionEvaluator {
    private static final ScriptEngineManager ENGINE_MANAGER = new ScriptEngineManager();
    private ScriptEngine engine;

    public SlimExpressionEvaluator() {
        this("JavaScript");
    }

    public SlimExpressionEvaluator(String engineName) {
        this(ENGINE_MANAGER.getEngineByName(engineName));
    }

    public SlimExpressionEvaluator(ScriptEngine engine) {
        this.engine = engine;
    }

    public void setContext(String expr, Map<String, MethodExecutionResult> variables) {
        Converter<Map> mapCnv = ConverterRegistry.getConverterForClass(Map.class);
        Converter<List> listCnv = ConverterRegistry.getConverterForClass(List.class);
        for (Map.Entry<String, MethodExecutionResult> entry : variables.entrySet()) {
            String key = entry.getKey();
            if (!expr.contains(key)) continue;
            Object value = entry.getValue().getObject();
            value = this.convertWikiHashes(mapCnv, value);
            value = this.convertWikiLists(listCnv, value);
            this.engine.put(key, value);
        }
    }

    protected Object convertWikiHashes(Converter<Map> cnv, Object value) {
        if ((value = this.convertWikiHash(cnv, value)) instanceof Map) {
            value = this.convertNestedWikiHashes(cnv, (Map)value);
        }
        return value;
    }

    protected Object convertWikiLists(Converter<List> cnv, Object value) {
        boolean mightBeList = value instanceof String;
        if (mightBeList) {
            String v = (String)value;
            if (GenericCollectionConverter.class.equals(cnv.getClass())) {
                boolean bl = mightBeList = v.startsWith("[") && v.endsWith("]");
            }
            if (mightBeList) {
                value = this.convertWikiList(cnv, v);
            }
        }
        return value;
    }

    protected Object convertWikiHash(Converter<Map> cnv, Object value) {
        Map mapObj;
        if (value instanceof String && !(mapObj = cnv.fromString((String)value)).isEmpty()) {
            value = mapObj;
        }
        return value;
    }

    protected Object convertNestedWikiHashes(Converter<Map> cnv, Map<String, ?> value) {
        LinkedHashMap newValue = new LinkedHashMap();
        newValue.putAll(value);
        for (Map.Entry nestedEntry : newValue.entrySet()) {
            Object nestedValue = this.convertWikiHashes(cnv, nestedEntry.getValue());
            newValue.put((String)nestedEntry.getKey(), nestedValue);
        }
        value = newValue;
        return value;
    }

    protected Object convertWikiList(Converter<List> cnv, String value) {
        return cnv.fromString(value);
    }

    public Object evaluate(String expression) {
        try {
            return this.engine.eval(expression);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("Unable to evaluate: " + expression + "; " + e.getMessage(), e);
        }
    }
}

