/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Library;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimError;
import fitnesse.slim.VariableStore;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlimExecutionContext {
    private final FixtureInteraction interaction;
    private Map<String, Object> instances = new HashMap<String, Object>();
    private List<Library> libraries = new ArrayList<Library>();
    private VariableStore variables = new VariableStore();
    private List<String> paths = new ArrayList<String>();

    public SlimExecutionContext(FixtureInteraction interaction) {
        this.interaction = interaction;
    }

    public List<Library> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    public void setVariable(String name, MethodExecutionResult value) {
        this.variables.setSymbol(name, value);
    }

    public MethodExecutionResult getVariable(String name) {
        return this.variables.getSymbol(name);
    }

    public void setVariable(String name, Object value) {
        this.setVariable(name, new MethodExecutionResult(value, Object.class));
    }

    public void create(String instanceName, String className, Object[] args) throws SlimError, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object potentialActor = this.variables.getStored(className);
        if (potentialActor != null && !(potentialActor instanceof String)) {
            this.addToInstancesOrLibrary(instanceName, potentialActor);
        } else {
            String replacedClassName = this.variables.replaceSymbolsInString(className);
            Object instance = this.interaction.createInstance(this.paths, replacedClassName, this.replaceSymbols(args));
            this.addToInstancesOrLibrary(instanceName, instance);
        }
    }

    public void addPath(String path) {
        if (!this.paths.contains(path)) {
            this.paths.add(0, path);
        }
    }

    public Object getInstance(String instanceName) {
        Object instance = this.instances.get(instanceName);
        if (instance != null) {
            return instance;
        }
        for (Library library : this.libraries) {
            if (!library.instanceName.equals(instanceName)) continue;
            return library.instance;
        }
        throw new SlimError(String.format("message:<<%s %s>>", "NO_INSTANCE", instanceName));
    }

    private void addToInstancesOrLibrary(String instanceName, Object instance) {
        if (this.isLibrary(instanceName)) {
            this.libraries.add(new Library(instanceName, instance));
        } else {
            this.setInstance(instanceName, instance);
        }
    }

    public void setInstance(String instanceName, Object instance) {
        this.instances.put(instanceName, instance);
    }

    private boolean isLibrary(String instanceName) {
        return instanceName.startsWith("library");
    }

    public Object[] replaceSymbols(Object[] args) {
        return this.variables.replaceSymbols(args);
    }

    public FixtureInteraction getInteraction() {
        return this.interaction;
    }
}

