/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionFactory;
import fitnesse.slim.instructions.InstructionResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListExecutor {
    private StatementExecutorInterface executor;
    private NameTranslator methodNameTranslator;
    private boolean verbose;

    public ListExecutor(SlimFactory slimFactory) {
        this(false, slimFactory);
    }

    protected ListExecutor(boolean verbose, SlimFactory slimFactory) {
        this.verbose = verbose;
        this.executor = slimFactory.getStatementExecutor();
        this.methodNameTranslator = slimFactory.getMethodNameTranslator();
    }

    protected void setVerbose() {
        this.verbose = true;
    }

    public List<Object> execute(List<Object> statements) {
        Executive e = this.verbose ? new LoggingExecutive() : new Executive();
        e.prepareToExecute();
        List<Object> result = e.executeStatements(statements);
        e.finalizeExecution();
        return result;
    }

    private List<Object> asStatementList(Object statement) {
        return (List)statement;
    }

    private void verboseMessage(Object message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }

    private class LoggingExecutive
    extends Executive {
        private LoggingExecutive() {
        }

        @Override
        public void prepareToExecute() {
            ListExecutor.this.verboseMessage("!1 Instructions");
        }

        @Override
        public Object executeStatement(Object statement) {
            List statementList = ListExecutor.this.asStatementList(statement);
            ListExecutor.this.verboseMessage(statementList + "\n");
            Object retVal = super.executeStatement(statement);
            ListExecutor.this.verboseMessage(retVal);
            ListExecutor.this.verboseMessage("------");
            return retVal;
        }
    }

    private class Executive {
        private Executive() {
        }

        public void prepareToExecute() {
        }

        public List<Object> executeStatements(List<Object> statements) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object statement : statements) {
                if (ListExecutor.this.executor.stopHasBeenRequested()) continue;
                result.add(this.executeStatement(statement));
            }
            return result;
        }

        public Object executeStatement(Object statement) {
            Instruction instruction = InstructionFactory.createInstruction(ListExecutor.this.asStatementList(statement), ListExecutor.this.methodNameTranslator);
            InstructionResult result = instruction.execute(ListExecutor.this.executor);
            Object resultObject = result.hasResult() || result.hasError() ? result.getResult() : null;
            return Arrays.asList(instruction.getId(), resultObject);
        }

        public void finalizeExecution() {
            if (ListExecutor.this.executor.stopHasBeenRequested()) {
                ListExecutor.this.executor.reset();
            }
        }
    }
}

