/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.components.TraversalListener;
import fitnesse.responders.search.ResultResponder;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.search.PageFinder;
import fitnesse.wiki.search.RegularExpressionWikiPageFinder;
import fitnesse.wiki.search.TitleWikiPageFinder;
import java.util.regex.Pattern;

public class SearchResponder
extends ResultResponder {
    private String getSearchString() {
        String searchString = this.request.getInput("searchString");
        return searchString == null ? "" : searchString;
    }

    private String getSearchType() {
        String searchType = this.request.getInput("searchType");
        if (searchType == null || searchType.toLowerCase().contains("title")) {
            return "Title";
        }
        return "Content";
    }

    protected String getPageFooterInfo(int hits) {
        return "Found " + hits + " results for your search.";
    }

    @Override
    protected String getTemplate() {
        return "searchForm";
    }

    @Override
    protected String getTitle() {
        return this.request.getInput("searchType") == null ? "Search Form" : this.getSearchType() + " Search Results for '" + this.getSearchString() + "'";
    }

    @Override
    protected PageFinder getPageFinder(TraversalListener<WikiPage> observer) {
        String searchString = this.getSearchString();
        if (!"".equals(searchString)) {
            String searchType = this.getSearchType();
            if ("Title".equals(searchType)) {
                return new TitleWikiPageFinder(searchString, observer);
            }
            Pattern regularExpression = Pattern.compile(searchString, 18);
            return new RegularExpressionWikiPageFinder(regularExpression, observer);
        }
        return null;
    }

    @Override
    protected boolean shouldRespondWith404() {
        return false;
    }
}

