/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.components.TraversalListener;
import fitnesse.responders.refactoring.SearchReplaceTraverser;
import fitnesse.responders.search.ResultResponder;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.refactoring.ContentReplacingSearchObserver;
import fitnesse.wiki.search.PageFinder;
import fitnesse.wiki.search.RegularExpressionWikiPageFinder;

public class SearchReplaceResponder
extends ResultResponder {
    protected String getPageFooterInfo(int hits) {
        return String.format("Replaced %d matches for your search.", hits);
    }

    @Override
    protected String getTemplate() {
        return "searchResults";
    }

    @Override
    protected String getTitle() {
        return String.format("Replacing matching content \"%s\" with content \"%s\"", this.getSearchString(), this.getReplacementString());
    }

    @Override
    protected PageFinder getPageFinder(TraversalListener<WikiPage> webOutputObserver) {
        String searchString = this.getSearchString();
        String replacementString = this.getReplacementString();
        ContentReplacingSearchObserver contentReplaceObserver = new ContentReplacingSearchObserver(searchString, replacementString);
        return new RegularExpressionWikiPageFinder(searchString, (TraversalListener<? super WikiPage>)new SearchReplaceTraverser(contentReplaceObserver, webOutputObserver));
    }

    private String getReplacementString() {
        return this.request.getInput("replacementString");
    }

    private String getSearchString() {
        return this.request.getInput("searchString");
    }
}

