/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.TraversalListener;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.wiki.NoPruningStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.List;

public class RefactorPageResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        String resource = request.getResource();
        String tags = "";
        WikiPage wikiPage = null;
        if (context.getRootPage() != null) {
            WikiPagePath path = PathParser.parse(resource);
            wikiPage = context.getRootPage().getPageCrawler().getPage(path);
            if (wikiPage != null) {
                PageData pageData = wikiPage.getData();
                tags = pageData.getAttribute("Suites");
            }
        }
        HtmlPage page = context.pageFactory.newPage();
        String type = request.getInput("type");
        page.setMainTemplate("refactorForm");
        page.setTitle("Refactor: " + resource);
        page.setPageTitle(new PageTitle("Refactor", PathParser.parse(resource), tags));
        page.put("refactoredRootPage", resource);
        page.put("request", request);
        page.put("type", type);
        page.put("viewLocation", request.getResource());
        if ("move".equals(type)) {
            page.put("suiteMap", this.collectPageNames(wikiPage, context.getRootPage()));
        }
        SimpleResponse response = new SimpleResponse();
        response.setContent(page.html(request));
        return response;
    }

    List<String> collectPageNames(WikiPage thisPage, WikiPage rootPage) {
        final ArrayList<String> pageNames = new ArrayList<String>();
        if (thisPage != null) {
            final WikiPagePath thisPagePath = thisPage.getFullPath();
            rootPage.getPageCrawler().traverse((TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

                @Override
                public void process(WikiPage page) {
                    WikiPagePath pagePath = page.getFullPath();
                    pagePath.makeAbsolute();
                    if (!thisPagePath.equals(pagePath) && !pagePath.isEmpty()) {
                        pageNames.add(pagePath.toString());
                    }
                }
            }, new NoPruningStrategy());
        }
        return pageNames;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

