/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import java.io.File;

public class DeleteConfirmationResponder
implements SecureResponder {
    private String resource;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        SimpleResponse response = new SimpleResponse();
        this.resource = request.getResource();
        String filename = request.getInput("filename");
        response.setContent(this.makeDirectoryListingPage(this.resource, filename, context, request));
        return response;
    }

    private String makeDirectoryListingPage(String pageName, String filename, FitNesseContext context, Request request) {
        HtmlPage page = context.pageFactory.newPage();
        page.setTitle("Delete File(s)");
        page.setPageTitle(new PageTitle("Delete File", this.resource + filename, "/"));
        page.put("resource", this.resource);
        this.makeConfirmationHTML(page, filename, context);
        page.setMainTemplate("deleteConfirmation");
        return page.html(request);
    }

    private void makeConfirmationHTML(HtmlPage page, String filename, FitNesseContext context) {
        String pathname = context.getRootPagePath() + "/" + this.resource + filename;
        File file = new File(pathname);
        boolean isDir = file.isDirectory();
        page.put("filename", filename);
        page.put("isDir", isDir);
        if (isDir) {
            page.put("nFiles", file.listFiles().length);
        }
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

