/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.MergeResponder;
import fitnesse.responders.editing.SaveRecorder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;

public class SaveResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        String resource;
        WikiPage page;
        long ticketId;
        long editTimeStamp = this.getEditTime(request);
        if (SaveRecorder.changesShouldBeMerged(editTimeStamp, ticketId = this.getTicketId(request), page = this.getPage(resource = request.getResource(), context))) {
            return new MergeResponder(request).makeResponse(context, request);
        }
        return this.saveEdits(context, request, page, ticketId);
    }

    private Response saveEdits(FitNesseContext context, Request request, WikiPage page, long ticketId) {
        String savedContent = request.getInput("pageContent");
        String helpText = request.getInput("helpText");
        String suites = request.getInput("suites");
        String user = request.getAuthorizationUsername();
        PageData data = page.getData();
        SimpleResponse response = new SimpleResponse();
        this.setData(data, savedContent, helpText, suites, user);
        SaveRecorder.pageSaved(page, ticketId);
        VersionInfo commitRecord = page.commit(data);
        if (commitRecord != null) {
            response.addHeader("Current-Version", commitRecord.getName());
        }
        context.recentChanges.updateRecentChanges(page);
        if (request.hasInput("redirect")) {
            response.redirect("", request.getInput("redirect"));
        } else {
            response.redirect(context.contextRoot, request.getResource());
        }
        return response;
    }

    private long getTicketId(Request request) {
        if (!request.hasInput("ticketId")) {
            return 0L;
        }
        String ticketIdString = request.getInput("ticketId");
        return Long.parseLong(ticketIdString);
    }

    private long getEditTime(Request request) {
        if (!request.hasInput("editTime")) {
            return 0L;
        }
        String editTimeStampString = request.getInput("editTime");
        return Long.parseLong(editTimeStampString);
    }

    private WikiPage getPage(String resource, FitNesseContext context) {
        WikiPagePath path = PathParser.parse(resource);
        PageCrawler pageCrawler = context.getRootPage().getPageCrawler();
        WikiPage page = pageCrawler.getPage(path);
        if (page == null) {
            page = WikiPageUtil.addPage(context.getRootPage(), PathParser.parse(resource));
        }
        return page;
    }

    private void setData(PageData data, String savedContent, String helpText, String suites, String user) {
        data.setContent(savedContent);
        data.setOrRemoveAttribute("Help", helpText);
        data.setOrRemoveAttribute("Suites", suites);
        data.setOrRemoveAttribute("LastModifyingUser", user);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }
}

