/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.editing.TemplateUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class WikiPageActions {
    private WikiPage page;

    public WikiPageActions(WikiPage page) {
        this.page = page;
    }

    public boolean isTestPage() {
        return this.hasAction("Test");
    }

    public boolean isSuitePage() {
        return this.hasAction("Suite");
    }

    public boolean isDefaultPage() {
        return !this.isTestPage() && !this.isSuitePage();
    }

    public boolean isWithEdit() {
        return this.hasAction("Edit");
    }

    public Map<String, String> getNewPageTemplates() {
        if (this.isWithEdit()) {
            Map<String, String> templates = TemplateUtil.getTemplatePageMap(this.page);
            Iterator<String> iter = templates.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                if (name.endsWith("Page")) continue;
                iter.remove();
            }
            return templates;
        }
        return Collections.emptyMap();
    }

    public boolean isWithProperties() {
        return this.hasAction("Properties");
    }

    public boolean isWithRefactor() {
        return this.hasAction("Refactor");
    }

    public boolean isWithWhereUsed() {
        return this.hasAction("WhereUsed");
    }

    public boolean isWithSearch() {
        return this.hasAction("Search");
    }

    public boolean isWithFiles() {
        return this.hasAction("Files");
    }

    public boolean isWithVersions() {
        return this.hasAction("Versions");
    }

    public boolean isWithRecentChanges() {
        return this.hasAction("RecentChanges");
    }

    public boolean isWithUserGuide() {
        return this.page != null;
    }

    public boolean isImported() {
        PageData data = this.getData();
        return data != null && WikiImportProperty.isImportedSubWiki(data);
    }

    private boolean hasAction(String action) {
        PageData data = this.getData();
        return data != null && data.hasAttribute(action);
    }

    private PageData getData() {
        if (this.page != null) {
            return this.page.getData();
        }
        return null;
    }

    public String getLocalPageName() {
        if (this.page != null) {
            WikiPagePath localPagePath = this.page.getFullPath();
            return PathParser.render(localPagePath);
        }
        return null;
    }
}

