/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.responders.FilteringResponder;
import fitnesse.responders.ImportAndViewResponder;
import fitnesse.responders.NameWikiPageResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.PacketResponder;
import fitnesse.responders.PageDataWikiPageResponder;
import fitnesse.responders.RawContentResponder;
import fitnesse.responders.RssResponder;
import fitnesse.responders.SerializedPageResponder;
import fitnesse.responders.ShutdownResponder;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.editing.AddChildPageResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.responders.editing.NewPageResponder;
import fitnesse.responders.editing.PropertiesResponder;
import fitnesse.responders.editing.SavePropertiesResponder;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.responders.editing.SymbolicLinkResponder;
import fitnesse.responders.files.CreateDirectoryResponder;
import fitnesse.responders.files.DeleteConfirmationResponder;
import fitnesse.responders.files.DeleteFileResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.responders.files.RenameFileConfirmationResponder;
import fitnesse.responders.files.RenameFileResponder;
import fitnesse.responders.files.UploadResponder;
import fitnesse.responders.refactoring.DeletePageResponder;
import fitnesse.responders.refactoring.MovePageResponder;
import fitnesse.responders.refactoring.RefactorPageResponder;
import fitnesse.responders.refactoring.RenamePageResponder;
import fitnesse.responders.refactoring.SearchReplaceResponder;
import fitnesse.responders.run.StopTestResponder;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.search.SearchPropertiesResponder;
import fitnesse.responders.search.SearchResponder;
import fitnesse.responders.search.WhereUsedResponder;
import fitnesse.responders.testHistory.ExecutionLogResponder;
import fitnesse.responders.testHistory.HistoryComparerResponder;
import fitnesse.responders.testHistory.PageHistoryResponder;
import fitnesse.responders.testHistory.PurgeHistoryResponder;
import fitnesse.responders.testHistory.SuiteOverviewResponder;
import fitnesse.responders.testHistory.TestHistoryResponder;
import fitnesse.responders.versions.RollbackResponder;
import fitnesse.responders.versions.VersionComparerResponder;
import fitnesse.responders.versions.VersionResponder;
import fitnesse.responders.versions.VersionSelectionResponder;
import fitnesse.wiki.PathParser;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class ResponderFactory {
    private static final Logger LOG = Logger.getLogger(ResponderFactory.class.getName());
    private final String rootPath;
    private final Map<String, Class<? extends Responder>> responderMap;
    private final Map<String, List<Responder>> filterMap;

    public ResponderFactory(String rootPath) {
        this.rootPath = rootPath;
        this.responderMap = new HashMap<String, Class<? extends Responder>>();
        this.addResponder("new", NewPageResponder.class);
        this.addResponder("edit", EditResponder.class);
        this.addResponder("saveData", SaveResponder.class);
        this.addResponder("search", SearchResponder.class);
        this.addResponder("searchForm", SearchResponder.class);
        this.addResponder("stoptest", StopTestResponder.class);
        this.addResponder("test", TestResponder.class);
        this.addResponder("suite", SuiteResponder.class);
        this.addResponder("proxy", SerializedPageResponder.class);
        this.addResponder("versions", VersionSelectionResponder.class);
        this.addResponder("viewVersion", VersionResponder.class);
        this.addResponder("rollback", RollbackResponder.class);
        this.addResponder("names", NameWikiPageResponder.class);
        this.addResponder("properties", PropertiesResponder.class);
        this.addResponder("saveProperties", SavePropertiesResponder.class);
        this.addResponder("searchProperties", SearchPropertiesResponder.class);
        this.addResponder("executeSearchProperties", SearchPropertiesResponder.class);
        this.addResponder("whereUsed", WhereUsedResponder.class);
        this.addResponder("refactor", RefactorPageResponder.class);
        this.addResponder("deletePage", DeletePageResponder.class);
        this.addResponder("renamePage", RenamePageResponder.class);
        this.addResponder("movePage", MovePageResponder.class);
        this.addResponder("pageData", PageDataWikiPageResponder.class);
        this.addResponder("createDir", CreateDirectoryResponder.class);
        this.addResponder("upload", UploadResponder.class);
        this.addResponder("deleteFile", DeleteFileResponder.class);
        this.addResponder("renameFile", RenameFileResponder.class);
        this.addResponder("deleteConfirmation", DeleteConfirmationResponder.class);
        this.addResponder("renameConfirmation", RenameFileConfirmationResponder.class);
        this.addResponder("raw", RawContentResponder.class);
        this.addResponder("rss", RssResponder.class);
        this.addResponder("import", WikiImportingResponder.class);
        this.addResponder("files", FileResponder.class);
        this.addResponder("shutdown", ShutdownResponder.class);
        this.addResponder("symlink", SymbolicLinkResponder.class);
        this.addResponder("importAndView", ImportAndViewResponder.class);
        this.addResponder("getPage", WikiPageResponder.class);
        this.addResponder("packet", PacketResponder.class);
        this.addResponder("testHistory", TestHistoryResponder.class);
        this.addResponder("pageHistory", PageHistoryResponder.class);
        this.addResponder("executionLog", ExecutionLogResponder.class);
        this.addResponder("addChild", AddChildPageResponder.class);
        this.addResponder("purgeHistory", PurgeHistoryResponder.class);
        this.addResponder("compareHistory", HistoryComparerResponder.class);
        this.addResponder("replace", SearchReplaceResponder.class);
        this.addResponder("overview", SuiteOverviewResponder.class);
        this.addResponder("compareVersions", VersionComparerResponder.class);
        this.filterMap = new HashMap<String, List<Responder>>();
    }

    public final void addResponder(String key, Class<? extends Responder> responderClass) {
        this.responderMap.put(key, responderClass);
    }

    public void addFilter(String key, Responder filterClass) {
        List<Responder> filters = this.filterMap.get(key);
        if (filters == null) {
            filters = new LinkedList<Responder>();
            this.filterMap.put(key, filters);
        }
        filters.add(filterClass);
    }

    public String getResponderKey(Request request) {
        String fullQuery = request.hasInput("responder") ? request.getInput("responder") : request.getQueryString();
        if (fullQuery == null) {
            return null;
        }
        int argStart = fullQuery.indexOf(38);
        return argStart <= 0 ? fullQuery : fullQuery.substring(0, argStart);
    }

    public Responder makeResponder(Request request) throws InstantiationException, IOException {
        String resource = request.getResource();
        String responderKey = this.getResponderKey(request);
        Responder responder = this.usingResponderKey(responderKey) ? this.wrapWithFilters(responderKey, this.lookupResponder(responderKey)) : (resource.startsWith("files/") || resource.equals("files") ? this.wrapWithFilters("files", new FileResponder()) : (StringUtils.isBlank(resource) || PathParser.parse(resource) != null ? this.wrapWithFilters("wiki", new WikiPageResponder()) : new NotFoundResponder()));
        return responder;
    }

    private Responder lookupResponder(String responderKey) throws InstantiationException {
        Class<?> responderClass = this.getResponderClass(responderKey);
        if (responderClass != null) {
            try {
                return this.newResponderInstance(responderClass);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to instantiate responder " + responderKey, e);
                throw new InstantiationException("Unable to instantiate responder " + responderKey);
            }
        }
        throw new InstantiationException("No responder for " + responderKey);
    }

    private Responder newResponderInstance(Class<?> responderClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Constructor<?> constructor = responderClass.getConstructor(String.class);
            return (Responder)constructor.newInstance(this.rootPath);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = responderClass.getConstructor(new Class[0]);
            return (Responder)constructor.newInstance(new Object[0]);
        }
    }

    private Responder wrapWithFilters(String key, Responder responder) throws InstantiationException {
        List<Responder> filters = this.filterMap.get(key);
        if (filters == null || filters.isEmpty()) {
            return responder;
        }
        return new FilteringResponder(filters, responder);
    }

    public Class<?> getResponderClass(String responderKey) {
        return this.responderMap.get(responderKey);
    }

    private boolean usingResponderKey(String responderKey) {
        return !"".equals(responderKey) && responderKey != null;
    }
}

