/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseContext;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.testrunner.WikiTestPageUtil;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.Expectation;
import fitnesse.testsystems.Instruction;
import fitnesse.testsystems.TableCell;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.util.DateTimeUtil;
import fitnesse.util.TimeMeasurement;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

public class TestXmlFormatter
extends BaseFormatter
implements ExecutionLogListener,
Closeable {
    private static final Logger LOG = Logger.getLogger(TestXmlFormatter.class.getName());
    private final FitNesseContext context;
    private final WriterFactory writerFactory;
    private TimeMeasurement currentTestStartTime;
    private TimeMeasurement totalTimeMeasurement;
    private StringBuilder outputBuffer;
    protected final TestExecutionReport testResponse;
    private TestExecutionReport.TestResult currentResult;

    public TestXmlFormatter(FitNesseContext context, WikiPage page, WriterFactory writerFactory) {
        super(page);
        this.context = context;
        this.writerFactory = writerFactory;
        this.totalTimeMeasurement = new TimeMeasurement().start();
        this.testResponse = new TestExecutionReport(context.version, page.getFullPath().toString());
        this.resetTimer();
    }

    public long startedAt() {
        return this.totalTimeMeasurement.startedAt();
    }

    public long runTime() {
        return this.currentTestStartTime.elapsed();
    }

    @Override
    public void testStarted(TestPage testPage) {
        this.resetTimer();
        this.appendHtmlToBuffer(WikiPageUtil.getHeaderPageHtml(this.getPage()));
        this.currentResult = this.newTestResult();
        this.currentResult.dateString = DateTimeUtil.formatDate(new Date());
        this.currentResult.relativePageName = testPage.getName();
        this.currentResult.tags = WikiTestPageUtil.getSourcePage(testPage).getData().getAttribute("Suites");
        this.testResponse.addResult(this.currentResult);
    }

    @Override
    public void testOutputChunk(String output) {
        this.appendHtmlToBuffer(output);
    }

    @Override
    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        if (testResult == null) {
            return;
        }
        Instruction instruction = assertion.getInstruction();
        Expectation expectation = assertion.getExpectation();
        TestExecutionReport.InstructionResult instructionResult = new TestExecutionReport.InstructionResult();
        this.currentResult.addInstruction(instructionResult);
        String id = instruction.getId();
        instructionResult.instruction = instruction.toString();
        instructionResult.slimResult = testResult.toString();
        try {
            TestExecutionReport.Expectation expectationResult = new TestExecutionReport.Expectation();
            instructionResult.addExpectation(expectationResult);
            expectationResult.instructionId = id;
            expectationResult.type = expectation.getClass().getSimpleName();
            expectationResult.actual = testResult.getActual();
            expectationResult.expected = testResult.getExpected();
            expectationResult.evaluationMessage = testResult.getMessage();
            if (testResult.getExecutionResult() != null) {
                expectationResult.status = testResult.getExecutionResult().toString();
            }
            if (expectation instanceof TableCell) {
                TableCell cell = (TableCell)((Object)expectation);
                expectationResult.col = Integer.toString(cell.getCol());
                expectationResult.row = Integer.toString(cell.getRow());
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to process assertion " + assertion + " with test result " + testResult, e);
        }
    }

    @Override
    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        Instruction instruction = assertion.getInstruction();
        Expectation expectation = assertion.getExpectation();
        TestExecutionReport.InstructionResult instructionResult = new TestExecutionReport.InstructionResult();
        this.currentResult.addInstruction(instructionResult);
        String id = instruction.getId();
        instructionResult.instruction = instruction.toString();
        try {
            TestExecutionReport.Expectation expectationResult = new TestExecutionReport.Expectation();
            instructionResult.addExpectation(expectationResult);
            expectationResult.instructionId = id;
            expectationResult.type = expectation.getClass().getSimpleName();
            expectationResult.evaluationMessage = exceptionResult.getMessage();
            expectationResult.status = exceptionResult.getExecutionResult().toString();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to process assertion " + assertion + " with exception result " + exceptionResult, e);
        }
    }

    @Override
    public void testComplete(TestPage test, TestSummary testSummary) {
        this.currentTestStartTime.stop();
        super.testComplete(test, testSummary);
        this.currentResult.startTime = this.currentTestStartTime.startedAt();
        this.addCountsToResult(this.currentResult, testSummary);
        this.currentResult.runTimeInMillis = String.valueOf(this.currentTestStartTime.elapsed());
        this.testResponse.tallyPageCounts(ExecutionResult.getExecutionResult(test.getName(), testSummary));
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        super.testSystemStopped(testSystem, cause);
        if (cause != null) {
            this.testResponse.tallyPageCounts(ExecutionResult.ERROR);
        }
    }

    protected TestExecutionReport.TestResult newTestResult() {
        return new TestExecutionReport.TestResult();
    }

    @Override
    public void close() throws IOException {
        this.setTotalRunTimeOnReport(this.totalTimeMeasurement);
        if (this.currentResult != null) {
            this.currentResult.content = this.outputBuffer == null ? null : this.outputBuffer.toString();
            this.outputBuffer = null;
        }
        this.writeResults();
    }

    private void resetTimer() {
        this.currentTestStartTime = new TimeMeasurement().start();
    }

    protected void setTotalRunTimeOnReport(TimeMeasurement totalTimeMeasurement) {
        this.testResponse.setTotalRunTimeInMillis(totalTimeMeasurement);
    }

    protected void writeResults() throws IOException {
        this.writeResults(this.writerFactory.getWriter(this.context, this.getPage(), this.getPageCounts(), this.totalTimeMeasurement.startedAt()));
    }

    @Override
    public int getErrorCount() {
        return this.getPageCounts().getWrong() + this.getPageCounts().getExceptions();
    }

    protected void writeResults(Writer writer) throws IOException {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", this.testResponse);
        Template template = this.context.pageFactory.getVelocityEngine().getTemplate("testResults.vm");
        template.merge(velocityContext, writer);
        writer.close();
    }

    protected TestSummary getPageCounts() {
        return this.testResponse.getFinalCounts();
    }

    private void addCountsToResult(TestExecutionReport.TestResult currentResult, TestSummary testSummary) {
        currentResult.right = Integer.toString(testSummary.getRight());
        currentResult.wrong = Integer.toString(testSummary.getWrong());
        currentResult.ignores = Integer.toString(testSummary.getIgnores());
        currentResult.exceptions = Integer.toString(testSummary.getExceptions());
    }

    private void appendHtmlToBuffer(String output) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new StringBuilder();
        }
        this.outputBuffer.append(output);
    }

    @Override
    public void commandStarted(ExecutionLogListener.ExecutionContext context) {
        this.testResponse.addExecutionContext(context.getCommand(), context.getTestSystemName());
    }

    @Override
    public void stdOut(String output) {
        this.testResponse.addStdOut(output);
    }

    @Override
    public void stdErr(String output) {
        this.testResponse.addStdErr(output);
    }

    @Override
    public void exitCode(int exitCode) {
        this.testResponse.exitCode(exitCode);
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        this.testResponse.exceptionOccurred(e);
    }

    public static interface WriterFactory {
        public Writer getWriter(FitNesseContext var1, WikiPage var2, TestSummary var3, long var4) throws IOException;
    }
}

