/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseContext;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestXmlFormatter;
import fitnesse.testrunner.WikiTestPageUtil;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.util.TimeMeasurement;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiPage;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import util.FileUtil;

public class SuiteHistoryFormatter
extends BaseFormatter
implements ExecutionLogListener,
Closeable {
    private final SuiteExecutionReport suiteExecutionReport;
    private final TimeMeasurement totalTimeMeasurement;
    private final FitNesseContext context;
    private final TestXmlFormatter.WriterFactory writerFactory;
    private SuiteExecutionReport.PageHistoryReference referenceToCurrentTest;
    private TimeMeasurement suiteTime;
    private TestXmlFormatter testHistoryFormatter;

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, TestXmlFormatter.WriterFactory source) {
        super(page);
        this.context = context;
        this.writerFactory = source;
        this.suiteExecutionReport = new SuiteExecutionReport(context.version, this.getPage().getFullPath().toString());
        this.totalTimeMeasurement = new TimeMeasurement().start();
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
        if (this.suiteTime == null) {
            this.suiteTime = new TimeMeasurement().start();
        }
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        super.testSystemStopped(testSystem, cause);
        if (cause != null) {
            this.suiteExecutionReport.tallyPageCounts(ExecutionResult.ERROR);
        }
        if (this.testHistoryFormatter != null) {
            FileUtil.close(this.testHistoryFormatter);
            this.testHistoryFormatter = null;
        }
    }

    @Override
    public void testStarted(TestPage test) {
        String pageName = test.getFullPath();
        this.testHistoryFormatter = new TestXmlFormatter(this.context, WikiTestPageUtil.getSourcePage(test), this.writerFactory);
        this.testHistoryFormatter.testStarted(test);
        this.referenceToCurrentTest = new SuiteExecutionReport.PageHistoryReference(pageName, this.testHistoryFormatter.startedAt());
    }

    @Override
    public void testOutputChunk(String output) {
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.testOutputChunk(output);
        }
    }

    @Override
    public void testComplete(TestPage test, TestSummary testSummary) {
        this.testHistoryFormatter.testComplete(test, testSummary);
        FileUtil.close(this.testHistoryFormatter);
        this.referenceToCurrentTest.setTestSummary(testSummary);
        this.referenceToCurrentTest.setRunTimeInMillis(this.testHistoryFormatter.runTime());
        this.suiteExecutionReport.addPageHistoryReference(this.referenceToCurrentTest);
        this.suiteExecutionReport.tallyPageCounts(ExecutionResult.getExecutionResult(test.getName(), testSummary));
        this.testHistoryFormatter = null;
        super.testComplete(test, testSummary);
    }

    @Override
    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        this.testHistoryFormatter.testAssertionVerified(assertion, testResult);
        super.testAssertionVerified(assertion, testResult);
    }

    @Override
    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.testHistoryFormatter.testExceptionOccurred(assertion, exceptionResult);
        super.testExceptionOccurred(assertion, exceptionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.suiteTime == null || this.suiteTime.isStopped()) {
            return;
        }
        this.suiteTime.stop();
        this.totalTimeMeasurement.stop();
        this.suiteExecutionReport.setTotalRunTimeInMillis(this.totalTimeMeasurement);
        if (this.testHistoryFormatter != null) {
            FileUtil.close(this.testHistoryFormatter);
        }
        if (PageType.fromWikiPage(this.getPage()) == PageType.SUITE) {
            Writer writer = this.writerFactory.getWriter(this.context, this.getPage(), this.getPageCounts(), this.suiteTime.startedAt());
            try {
                VelocityContext velocityContext = new VelocityContext();
                velocityContext.put("suiteExecutionReport", this.getSuiteExecutionReport());
                VelocityEngine velocityEngine = this.context.pageFactory.getVelocityEngine();
                Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
                template.merge(velocityContext, writer);
            }
            finally {
                FileUtil.close(writer);
            }
        }
    }

    @Override
    public int getErrorCount() {
        return this.getPageCounts().getWrong() + this.getPageCounts().getExceptions();
    }

    public List<SuiteExecutionReport.PageHistoryReference> getPageHistoryReferences() {
        return this.suiteExecutionReport.getPageHistoryReferences();
    }

    public TestSummary getPageCounts() {
        return this.suiteExecutionReport.getFinalCounts();
    }

    public SuiteExecutionReport getSuiteExecutionReport() {
        return this.suiteExecutionReport;
    }

    @Override
    public void commandStarted(ExecutionLogListener.ExecutionContext context) {
        this.suiteExecutionReport.addExecutionContext(context.getCommand(), context.getTestSystemName());
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.commandStarted(context);
        }
    }

    @Override
    public void stdOut(String output) {
        this.suiteExecutionReport.addStdOut(output);
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.stdOut(output);
        }
    }

    @Override
    public void stdErr(String output) {
        this.suiteExecutionReport.addStdErr(output);
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.stdErr(output);
        }
    }

    @Override
    public void exitCode(int exitCode) {
        this.suiteExecutionReport.exitCode(exitCode);
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.exitCode(exitCode);
        }
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        this.suiteExecutionReport.exceptionOccurred(e);
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.exceptionOccurred(e);
        }
    }
}

