/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.plugins;

import fitnesse.authentication.Authenticator;
import fitnesse.authentication.MultiUserAuthenticator;
import fitnesse.authentication.OneUserAuthenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.components.ComponentFactory;
import fitnesse.plugins.PluginException;
import fitnesse.plugins.PluginFeatureFactory;
import fitnesse.plugins.PropertyBasedPluginFeatureFactory;
import fitnesse.reporting.FormatterRegistry;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.testrunner.TestSystemFactoryRegistry;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wikitext.parser.SymbolProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public class PluginsLoader {
    private static final Logger LOG = Logger.getLogger(PluginsLoader.class.getName());
    private final ComponentFactory componentFactory;
    private final ClassLoader classLoader;
    private final Collection<PluginFeatureFactory> pluginFeatureFactories;

    public PluginsLoader(ComponentFactory componentFactory, ClassLoader classLoader) throws PluginException {
        this.componentFactory = componentFactory;
        this.classLoader = classLoader;
        this.pluginFeatureFactories = this.findPluginFeatureFactories();
    }

    private Collection<PluginFeatureFactory> findPluginFeatureFactories() throws PluginException {
        ArrayList<PluginFeatureFactory> factories = new ArrayList<PluginFeatureFactory>();
        factories.addAll(PropertyBasedPluginFeatureFactory.loadFromProperties(this.componentFactory));
        for (PluginFeatureFactory factory : ServiceLoader.load(PluginFeatureFactory.class, this.classLoader)) {
            factories.add(factory);
        }
        return factories;
    }

    public void loadResponders(ResponderFactory responderFactory) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerResponders(responderFactory);
        }
    }

    public fitnesse.components.Logger makeLogger(String logDirectory) {
        return logDirectory != null ? new fitnesse.components.Logger(logDirectory) : null;
    }

    public Authenticator makeAuthenticator(String authenticationParameter) throws IOException, PluginException {
        Authenticator authenticator = new PromiscuousAuthenticator();
        if (authenticationParameter != null) {
            if (new File(authenticationParameter).exists()) {
                try {
                    authenticator = new MultiUserAuthenticator(authenticationParameter);
                }
                catch (ReflectiveOperationException e) {
                    throw new PluginException("Could not instantiate authentication classes", e);
                }
            } else {
                String[] values = authenticationParameter.split(":");
                authenticator = new OneUserAuthenticator(values[0], values[1]);
            }
        }
        return this.getAuthenticator(authenticator);
    }

    public Authenticator getAuthenticator(Authenticator defaultAuthenticator) {
        PluginFeatureFactory pff;
        Authenticator authenticator = null;
        Iterator<PluginFeatureFactory> iterator = this.pluginFeatureFactories.iterator();
        while (iterator.hasNext() && (authenticator = (pff = iterator.next()).getAuthenticator()) == null) {
        }
        return authenticator == null ? defaultAuthenticator : authenticator;
    }

    public String getDefaultTheme() {
        PluginFeatureFactory pff;
        String theme = null;
        Iterator<PluginFeatureFactory> iterator = this.pluginFeatureFactories.iterator();
        while (iterator.hasNext() && (theme = (pff = iterator.next()).getDefaultTheme()) == null) {
        }
        return theme;
    }

    public void loadSymbolTypes(SymbolProvider symbolProvider) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerSymbolTypes(symbolProvider);
        }
    }

    public void loadWikiPageFactories(WikiPageFactoryRegistry registrar) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerWikiPageFactories(registrar);
        }
    }

    public void loadFormatters(FormatterRegistry registrar) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerFormatters(registrar);
        }
    }

    public ContentFilter loadContentFilter() {
        PluginFeatureFactory pff;
        ContentFilter filter = null;
        Iterator<PluginFeatureFactory> iterator = this.pluginFeatureFactories.iterator();
        while (iterator.hasNext() && (filter = (pff = iterator.next()).getContentFilter()) == null) {
        }
        if (filter != null) {
            LOG.info("Content filter installed: " + filter.getClass().getName());
        }
        return filter;
    }

    public void loadSlimTables(SlimTableFactory slimTableFactory) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerSlimTables(slimTableFactory);
        }
    }

    public void loadCustomComparators(CustomComparatorRegistry customComparatorRegistry) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerCustomComparators(customComparatorRegistry);
        }
    }

    public void loadTestSystems(TestSystemFactoryRegistry registrar) throws PluginException {
        for (PluginFeatureFactory pff : this.pluginFeatureFactories) {
            pff.registerTestSystemFactories(registrar);
        }
    }
}

