/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.plugins;

import fitnesse.plugins.PluginException;
import fitnesse.plugins.PluginFeatureFactoryBase;
import fitnesse.responders.ResponderFactory;
import fitnesse.testrunner.TestSystemFactoryRegistry;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wikitext.parser.SymbolProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LegacyPluginFeatureFactory
extends PluginFeatureFactoryBase {
    private final Object plugin;

    public LegacyPluginFeatureFactory(Object plugin) {
        this.plugin = plugin;
    }

    @Override
    public void registerResponders(ResponderFactory responderFactory) throws PluginException {
        if (this.register(this.plugin, "registerResponders", ResponderFactory.class, responderFactory)) {
            this.LOG.info("Registered responders from: " + this.getPluginDescription());
        }
    }

    @Override
    public void registerSymbolTypes(SymbolProvider symbolProvider) throws PluginException {
        if (this.register(this.plugin, "registerSymbolTypes", SymbolProvider.class, symbolProvider)) {
            this.LOG.info("Registered Symbol types from: " + this.getPluginDescription());
        }
    }

    @Override
    public void registerWikiPageFactories(WikiPageFactoryRegistry wikiPageFactoryRegistry) throws PluginException {
        if (this.register(this.plugin, "registerWikiPageFactories", WikiPageFactoryRegistry.class, wikiPageFactoryRegistry)) {
            this.LOG.info("Registered wiki page factories from: " + this.getPluginDescription());
        }
    }

    @Override
    public void registerTestSystemFactories(TestSystemFactoryRegistry testSystemFactoryRegistry) throws PluginException {
        if (this.register(this.plugin, "registerTestSystemFactories", TestSystemFactoryRegistry.class, testSystemFactoryRegistry)) {
            this.LOG.info("Registered test system factories from: " + this.getPluginDescription());
        }
    }

    @Override
    public void registerSlimTables(SlimTableFactory slimTableFactory) throws PluginException {
        if (this.register(this.plugin, "registerSlimTableFactories", SlimTableFactory.class, slimTableFactory)) {
            this.LOG.info("Registered Slim table factories from: " + this.getPluginDescription());
        }
    }

    @Override
    public void registerCustomComparators(CustomComparatorRegistry customComparatorRegistry) throws PluginException {
        if (this.register(this.plugin, "registerCustomComparatorRegistries", CustomComparatorRegistry.class, customComparatorRegistry)) {
            this.LOG.info("Registered custom comparator registries from: " + this.getPluginDescription());
        }
    }

    protected String getPluginDescription() {
        return this.plugin.getClass().getName();
    }

    private <T> boolean register(Object plugin, String methodName, Class<T> registrarType, T registrar) throws PluginException {
        Method method;
        try {
            method = plugin.getClass().getMethod(methodName, registrarType);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        try {
            method.invoke(plugin, registrar);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PluginException("Unable to execute method " + methodName, e);
        }
        return true;
    }
}

