/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.DescriptionFactory;
import fitnesse.testrunner.TestsRunnerListener;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnitRunNotifierResultsListener
implements TestSystemListener,
TestsRunnerListener,
Closeable {
    private static final Logger LOG = Logger.getLogger(JUnitRunNotifierResultsListener.class.getName());
    private final Class<?> mainClass;
    private final RunNotifier notifier;
    private final DescriptionFactory descriptionFactory;
    private int totalNumberOfTests;
    private int completedTests;
    private Throwable firstFailure;

    public JUnitRunNotifierResultsListener(RunNotifier notifier, Class<?> mainClass, DescriptionFactory descriptionFactory) {
        this.notifier = notifier;
        this.mainClass = mainClass;
        this.descriptionFactory = descriptionFactory;
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
        this.totalNumberOfTests = testsToRun;
    }

    @Override
    public void unableToStartTestSystem(String testSystemName, Throwable cause) {
        this.notifyOfTestSystemException(testSystemName, cause);
    }

    @Override
    public void testStarted(TestPage test) {
        this.firstFailure = null;
        this.notifier.fireTestStarted(this.descriptionFor(test));
    }

    @Override
    public void testComplete(TestPage test, TestSummary testSummary) {
        this.increaseCompletedTests();
        Description description = this.descriptionFor(test);
        if (this.firstFailure != null) {
            this.notifier.fireTestFailure(new Failure(description, this.firstFailure));
        } else if (testSummary.getExceptions() > 0) {
            this.notifier.fireTestFailure(new Failure(description, (Throwable)new Exception("Exception occurred on page " + test.getFullPath())));
        } else if (testSummary.getWrong() > 0) {
            this.notifier.fireTestFailure(new Failure(description, (Throwable)((Object)new AssertionError((Object)("Test failures occurred on page " + test.getFullPath())))));
        }
        this.notifier.fireTestFinished(description);
    }

    @Override
    public void testOutputChunk(String output) {
    }

    @Override
    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        if (testResult != null && testResult.doesCount() && (testResult.getExecutionResult() == ExecutionResult.FAIL || testResult.getExecutionResult() == ExecutionResult.ERROR)) {
            this.firstFailure(testResult.getExecutionResult(), this.createMessage(testResult));
        }
    }

    @Override
    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        String message = exceptionResult.getMessage();
        if (message == null && exceptionResult instanceof SlimExceptionResult) {
            message = this.extractMessageFromSlimException((SlimExceptionResult)exceptionResult);
        }
        this.firstFailure(exceptionResult.getExecutionResult(), message);
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        this.notifyOfTestSystemException(testSystem.getName(), cause);
    }

    @Override
    public void close() {
        String msg;
        if (this.completedTests < this.totalNumberOfTests) {
            msg = String.format("Not all tests executed. Completed %s of %s tests.", this.completedTests, this.totalNumberOfTests);
            Exception e = new Exception(msg);
            this.notifier.fireTestFailure(new Failure(this.suiteDescription(), (Throwable)e));
        }
        if (this.completedTests > this.totalNumberOfTests && LOG.isLoggable(Level.WARNING)) {
            msg = String.format("Too many tests completed. Completed %s of %s tests.", this.completedTests, this.totalNumberOfTests);
            LOG.log(Level.WARNING, msg);
        }
    }

    protected String extractMessageFromSlimException(SlimExceptionResult slimExceptionResult) {
        String slimExceptionMessage = slimExceptionResult.getException();
        String result = slimExceptionMessage.replace("__EXCEPTION__:", "");
        int index = result.indexOf("\n\tat fitnesse.slim.MethodExecutor.findAndInvoke(");
        if (index > 0) {
            result = result.substring(0, index);
        }
        return result;
    }

    protected void notifyOfTestSystemException(String testSystemName, Throwable cause) {
        if (cause != null) {
            Exception e = new Exception("Exception while executing tests using: " + testSystemName, cause);
            this.notifier.fireTestFailure(new Failure(this.suiteDescription(), (Throwable)e));
        }
    }

    private Description suiteDescription() {
        return this.getDescriptionFactory().createSuiteDescription(this.getMainClass());
    }

    protected Description descriptionFor(TestPage test) {
        return this.getDescriptionFactory().createDescription(this.getMainClass(), test);
    }

    String createMessage(TestResult testResult) {
        if (testResult.hasActual() && testResult.hasExpected()) {
            return String.format("[%s] expected [%s]", testResult.getActual(), testResult.getExpected());
        }
        if ((testResult.hasActual() || testResult.hasExpected()) && testResult.hasMessage()) {
            return String.format("[%s] %s", testResult.hasActual() ? testResult.getActual() : testResult.getExpected(), testResult.getMessage());
        }
        return testResult.getMessage();
    }

    private void firstFailure(ExecutionResult executionResult, String message) {
        if (this.firstFailure != null) {
            return;
        }
        this.firstFailure = executionResult == ExecutionResult.ERROR ? new Exception(message) : (message == null ? new AssertionError() : new AssertionError((Object)message));
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public RunNotifier getNotifier() {
        return this.notifier;
    }

    public DescriptionFactory getDescriptionFactory() {
        return this.descriptionFactory;
    }

    public int getTotalNumberOfTests() {
        return this.totalNumberOfTests;
    }

    protected void increaseCompletedTests() {
        ++this.completedTests;
    }

    public int getCompletedTests() {
        return this.completedTests;
    }

    public Throwable getFirstFailure() {
        return this.firstFailure;
    }

    protected void setFirstFailure(Throwable firstFailure) {
        this.firstFailure = firstFailure;
    }
}

