/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.FitNessePageAnnotation;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;

public class DescriptionHelper {
    private DescriptionHelper() {
    }

    public static WikiPage getWikiPage(Description description) {
        WikiPage result = null;
        FitNessePageAnnotation pageAnn = (FitNessePageAnnotation)description.getAnnotation(FitNessePageAnnotation.class);
        if (pageAnn != null) {
            result = pageAnn.getWikiPage();
        }
        return result;
    }

    public static TestPage getTestPage(Description description) {
        TestPage result = null;
        FitNessePageAnnotation pageAnn = (FitNessePageAnnotation)description.getAnnotation(FitNessePageAnnotation.class);
        if (pageAnn != null) {
            result = pageAnn.getTestPage();
        }
        return result;
    }

    public static List<String> getPageTags(Description description) {
        List<String> result = Collections.emptyList();
        WikiPage wikiPage = DescriptionHelper.getWikiPage(description);
        if (wikiPage != null) {
            result = DescriptionHelper.getPageTags(wikiPage);
        }
        return result;
    }

    public static List<String> getPageTags(WikiPage page) {
        String suitesValue;
        List<String> result = Collections.emptyList();
        PageData data = page.getData();
        if (data != null && (suitesValue = StringUtils.stripToNull(data.getProperties().get("Suites"))) != null) {
            result = Arrays.asList(suitesValue.split("\\s*,\\s*"));
        }
        return result;
    }
}

