/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import util.FileUtil;
import util.StreamReader;

public class RequestBuilder {
    private static final byte[] ENDL = "\r\n".getBytes();
    private static final Random RANDOM_GENERATOR = new SecureRandom();
    private String resource;
    private String method = "GET";
    private List<InputStream> bodyParts = new LinkedList<InputStream>();
    private HashMap<String, String> headers = new HashMap();
    private HashMap<String, Object> inputs = new HashMap();
    private String host;
    private int port;
    private String boundary;
    private boolean isMultipart = false;
    private int bodyLength = 0;

    public RequestBuilder(String resource) {
        this.resource = resource;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public String getText() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.send(output);
        return output.toString();
    }

    private String buildRequestLine() throws UnsupportedEncodingException {
        String inputString;
        StringBuilder text = new StringBuilder();
        text.append(this.method).append(" ").append(this.resource);
        if (this.isGet() && !(inputString = this.inputString()).isEmpty()) {
            text.append("?").append(inputString);
        }
        text.append(" HTTP/1.1");
        return text.toString();
    }

    private boolean isGet() {
        return this.method.equals("GET");
    }

    public void send(OutputStream output) throws IOException {
        output.write(this.buildRequestLine().getBytes(FileUtil.CHARENCODING));
        output.write(ENDL);
        this.buildBody();
        this.sendHeaders(output);
        output.write(ENDL);
        this.sendBody(output);
    }

    private void sendHeaders(OutputStream output) throws IOException {
        this.addHostHeader();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            output.write((entry.getKey() + ": " + entry.getValue()).getBytes(FileUtil.CHARENCODING));
            output.write(ENDL);
        }
    }

    private void buildBody() throws IOException {
        if (!this.isMultipart) {
            byte[] bytes = this.inputString().getBytes(FileUtil.CHARENCODING);
            this.bodyParts.add(new ByteArrayInputStream(bytes));
            this.bodyLength += bytes.length;
        } else {
            for (Map.Entry<String, Object> entry : this.inputs.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                StringBuilder partBuffer = new StringBuilder();
                partBuffer.append("--").append(this.getBoundary()).append("\r\n");
                partBuffer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append("\r\n");
                if (value instanceof InputStreamPart) {
                    InputStreamPart part = (InputStreamPart)value;
                    partBuffer.append("Content-Type: ").append(part.contentType).append("\r\n");
                    partBuffer.append("\r\n");
                    this.addBodyPart(partBuffer.toString());
                    this.bodyParts.add(part.input);
                    this.bodyLength += part.size;
                    this.addBodyPart("\r\n");
                    continue;
                }
                partBuffer.append("Content-Type: text/plain").append("\r\n");
                partBuffer.append("\r\n");
                partBuffer.append(value);
                partBuffer.append("\r\n");
                this.addBodyPart(partBuffer.toString());
            }
            String tail = "--" + this.getBoundary() + "--\r\n";
            this.addBodyPart(tail);
        }
        this.addHeader("Content-Length", this.bodyLength + "");
    }

    private void addBodyPart(String input) throws UnsupportedEncodingException {
        byte[] bytes = input.getBytes(FileUtil.CHARENCODING);
        this.bodyParts.add(new ByteArrayInputStream(bytes));
        this.bodyLength += bytes.length;
    }

    private void sendBody(OutputStream output) throws IOException {
        for (InputStream input : this.bodyParts) {
            StreamReader reader = new StreamReader(input);
            while (!reader.isEof()) {
                byte[] bytes = reader.readBytes(1000);
                output.write(bytes);
            }
        }
    }

    private void addHostHeader() {
        if (this.host != null) {
            this.addHeader("Host", this.host + ":" + this.port);
        } else {
            this.addHeader("Host", "");
        }
    }

    public void addInput(String key, Object value) {
        this.inputs.put(key, value);
    }

    public String inputString() throws UnsupportedEncodingException {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.inputs.entrySet()) {
            String value = (String)entry.getValue();
            if (!first) {
                buffer.append("&");
            }
            String key = entry.getKey();
            buffer.append(key).append("=").append(URLEncoder.encode(value, FileUtil.CHARENCODING));
            first = false;
        }
        return buffer.toString();
    }

    public void addCredentials(String username, String password) {
        String rawUserpass = username + ":" + password;
        String userpass = Base64.encode(rawUserpass);
        this.addHeader("Authorization", "Basic " + userpass);
    }

    public void setHostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getBoundary() {
        if (this.boundary == null) {
            this.boundary = "----------" + RANDOM_GENERATOR.nextInt() + "BoUnDaRy";
        }
        return this.boundary;
    }

    public void addInputAsPart(String name, Object content) {
        this.multipart();
        this.addInput(name, content);
    }

    public void addInputAsPart(String name, InputStream input, int size, String contentType) {
        this.addInputAsPart(name, new InputStreamPart(input, size, contentType));
    }

    private void multipart() {
        if (!this.isMultipart) {
            this.isMultipart = true;
            this.setMethod("POST");
            this.addHeader("Content-Type", "multipart/form-data; boundary=" + this.getBoundary());
        }
    }

    private static class InputStreamPart {
        public InputStream input;
        public int size;
        public String contentType;

        public InputStreamPart(InputStream input, int size, String contentType) {
            this.input = input;
            this.size = size;
            this.contentType = contentType;
        }
    }
}

