/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html.template;

import fitnesse.FitNesseContext;
import fitnesse.html.template.ClasspathResourceLoader;
import fitnesse.html.template.EscapeDirective;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.TraverseDirective;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import util.FileUtil;

public class PageFactory {
    private final String theme;
    private final String contextRoot;
    private VelocityEngine velocityEngine = null;

    public PageFactory(FitNesseContext context) {
        this.theme = context.theme;
        this.velocityEngine = this.newVelocityEngine(context.getRootPagePath(), this.theme);
        this.contextRoot = context.contextRoot;
    }

    public HtmlPage newPage() {
        return new HtmlPage(this.getVelocityEngine(), "skeleton.vm", this.theme, this.contextRoot);
    }

    public String render(VelocityContext context, String templateName) {
        StringWriter writer = new StringWriter();
        Template template = this.getVelocityEngine().getTemplate(templateName, FileUtil.CHARENCODING);
        template.merge(context, writer);
        return ((Object)writer).toString();
    }

    public String getTheme() {
        return this.theme;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private VelocityEngine newVelocityEngine(String rootPagePath, String theme) {
        Properties properties = new Properties();
        properties.setProperty("directive.if.emptycheck", "false");
        properties.setProperty("input.encoding", FileUtil.CHARENCODING);
        properties.setProperty("resource.loader", "file,themepath,classpath");
        properties.setProperty("file.resource.loader.path", String.format("%s/files/fitnesse/templates", rootPagePath));
        properties.setProperty("themepath.resource.loader.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("themepath.resource.loader.base", String.format("/fitnesse/resources/%s/templates", theme));
        properties.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("classpath.resource.loader.base", "/fitnesse/resources/templates");
        VelocityEngine engine = new VelocityEngine();
        engine.init(properties);
        engine.loadDirective(TraverseDirective.class.getName());
        engine.loadDirective(EscapeDirective.class.getName());
        return engine;
    }
}

