/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.LogData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Logger {
    private File directory;
    private PrintWriter writer;
    private Calendar currentFileCreationDate;

    public static SimpleDateFormat makeLogFormat() {
        return new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    }

    public static SimpleDateFormat makeFileNameFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public Logger(String dirPath) {
        this.directory = new File(dirPath);
        this.directory.mkdir();
    }

    public File getDirectory() {
        return this.directory;
    }

    String formatLogLine(LogData data) {
        StringBuilder line = new StringBuilder();
        line.append(data.host).append(" - ");
        line.append(data.username == null ? "-" : data.username);
        line.append(" [").append(Logger.format(Logger.makeLogFormat(), data.time)).append("] ");
        line.append('\"').append(data.requestLine).append("\" ");
        line.append(data.status).append(" ");
        line.append(data.size);
        return line.toString();
    }

    static String makeLogFileName(Calendar calendar) {
        return "fitnesse" + Logger.format(Logger.makeFileNameFormat(), calendar) + ".log";
    }

    public void log(LogData data) {
        if (this.needNewFile(data.time)) {
            this.openNewFile(data);
        }
        this.writer.println(this.formatLogLine(data));
        this.writer.flush();
    }

    private boolean needNewFile(Calendar time) {
        if (this.writer == null) {
            return true;
        }
        boolean different = time.get(6) != this.currentFileCreationDate.get(6) || time.get(1) != this.currentFileCreationDate.get(1);
        return different;
    }

    private void openNewFile(LogData data) {
        OutputStream outputStream;
        if (this.writer != null) {
            this.writer.close();
        }
        this.currentFileCreationDate = data.time;
        String filename = Logger.makeLogFileName(data.time);
        File file = new File(this.directory, filename);
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to open log file. Falling back to stderr");
            e.printStackTrace(System.err);
            outputStream = System.err;
        }
        this.writer = new PrintWriter(outputStream);
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private static String format(DateFormat format, Calendar calendar) {
        DateFormat tmpFormat = (DateFormat)format.clone();
        tmpFormat.setTimeZone(calendar.getTimeZone());
        return tmpFormat.format(calendar.getTime());
    }

    public String toString() {
        return this.getDirectory().getAbsolutePath();
    }
}

