/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.TransparentCipher;
import fitnesse.util.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import util.FileUtil;

public class PasswordFile {
    private final File passwordFile;
    private Map<String, String> passwordMap = new HashMap<String, String>();
    private PasswordCipher cipher = new TransparentCipher();

    public PasswordFile(String filename) throws IOException, ReflectiveOperationException {
        this.passwordFile = new File(filename);
        this.loadFile();
    }

    public PasswordFile(String filename, PasswordCipher cipher) throws IOException, ReflectiveOperationException {
        this(filename);
        this.cipher = cipher;
    }

    public Map<String, String> getPasswordMap() {
        return this.passwordMap;
    }

    public String getName() {
        return this.passwordFile.getName();
    }

    public PasswordCipher getCipher() {
        return this.cipher;
    }

    public void savePassword(String user, String password) throws IOException {
        this.passwordMap.put(user, this.cipher.encrypt(password));
        this.savePasswords();
    }

    private void loadFile() throws IOException, ReflectiveOperationException {
        LinkedList<String> lines = this.getPasswordFileLines();
        this.loadCipher(lines);
        this.loadPasswords(lines);
    }

    private void loadPasswords(LinkedList<String> lines) {
        for (String line : lines) {
            if ("".equals(line)) continue;
            String[] tokens = line.split(":");
            this.passwordMap.put(tokens[0], tokens[1]);
        }
    }

    private void loadCipher(LinkedList<String> lines) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        String firstLine;
        if (!lines.isEmpty() && (firstLine = lines.getFirst()).startsWith("!")) {
            String cipherClassName = firstLine.substring(1);
            this.instantiateCipher(cipherClassName);
            lines.removeFirst();
        }
    }

    public PasswordCipher instantiateCipher(String cipherClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.cipher = (PasswordCipher)ClassUtils.forName(cipherClassName).newInstance();
        return this.cipher;
    }

    private void savePasswords() throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("!" + this.cipher.getClass().getName());
        for (Map.Entry<String, String> entry : this.passwordMap.entrySet()) {
            String user = entry.getKey();
            String password = entry.getValue();
            lines.add(user + ":" + password);
        }
        FileUtil.writeLinesToFile(this.passwordFile, lines);
    }

    private LinkedList<String> getPasswordFileLines() throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        if (this.passwordFile.exists()) {
            lines.addAll(FileUtil.getFileLines(this.passwordFile));
        }
        return lines;
    }
}

