/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.LogData;
import fitnesse.http.EmptyRequestException;
import fitnesse.http.HttpException;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.GregorianCalendar;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class FitNesseExpediter
implements ResponseSender,
Runnable {
    private static final Logger LOG = Logger.getLogger(FitNesseExpediter.class.getName());
    private final Socket socket;
    private final InputStream input;
    private final OutputStream output;
    private final FitNesseContext context;
    private final ExecutorService executorService;
    private final long requestParsingTimeLimit;
    private Request request;
    private Response response;

    public FitNesseExpediter(Socket socket, FitNesseContext context, ExecutorService executorService) throws IOException {
        this(socket, context, executorService, 10000L);
    }

    public FitNesseExpediter(Socket socket, FitNesseContext context, ExecutorService executorService, long requestParsingTimeLimit) throws IOException {
        this.context = context;
        this.socket = socket;
        this.executorService = executorService;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.requestParsingTimeLimit = requestParsingTimeLimit;
    }

    @Override
    public void run() {
        try {
            this.request = this.makeRequest();
            this.response = this.makeResponse(this.request);
            this.sendResponse(this.response);
        }
        catch (SocketException socketException) {
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Unexpected exception", e);
        }
    }

    @Override
    public void send(byte[] bytes) throws IOException {
        this.output.write(bytes);
        this.output.flush();
    }

    @Override
    public void close() {
        this.log(this.socket, this.request, this.response);
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error while closing socket", e);
            }
        }
    }

    private Request makeRequest() {
        Request request = new Request(this.input);
        request.setContextRoot(this.context.contextRoot);
        return request;
    }

    private void sendResponse(Response response) throws IOException {
        response.sendTo(this);
    }

    private Response makeResponse(final Request request) throws Exception {
        Response response;
        try {
            try {
                this.executorService.submit(new Callable<Request>(){

                    @Override
                    public Request call() throws Exception {
                        request.parse();
                        return request;
                    }
                }).get(this.requestParsingTimeLimit, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
            if (request.hasBeenParsed()) {
                if (this.context.contextRoot.equals(request.getRequestUri() + "/")) {
                    response = new SimpleResponse();
                    response.redirect(this.context.contextRoot, "");
                } else {
                    response = this.createGoodResponse(request);
                }
            } else {
                response = this.reportError(request, 400, "The request could not be parsed.");
            }
        }
        catch (SocketException se) {
            throw se;
        }
        catch (TimeoutException e) {
            String message = "The client request has been unproductive for too long. It has timed out and will no longer be processed.";
            LOG.log(Level.FINE, message, e);
            response = this.reportError(request, 408, message);
        }
        catch (EmptyRequestException e) {
            LOG.log(Level.FINER, "Browser 'keep alive' request, will be ignored", e);
            response = this.reportError(request, 400, e.getMessage());
        }
        catch (HttpException e) {
            LOG.log(Level.FINE, "An error occured while fulfilling user request", e);
            response = this.reportError(request, 400, e.getMessage());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "An error occured while fulfilling user request", e);
            response = this.reportError(request, e);
        }
        response.addHeader("Server", "FitNesse-" + this.context.version);
        response.addHeader("Connection", "close");
        return response;
    }

    public Response createGoodResponse(Request request) throws Exception {
        if (StringUtils.isBlank(request.getResource()) && StringUtils.isBlank(request.getQueryString())) {
            request.setResource("FrontPage");
        }
        Responder responder = this.context.responderFactory.makeResponder(request);
        responder = this.context.authenticator.authenticate(this.context, request, responder);
        return responder.makeResponse(this.context, request);
    }

    private Response reportError(Request request, int status, String message) throws Exception {
        return new ErrorResponder(message, status).makeResponse(this.context, request);
    }

    private Response reportError(Request request, Exception e) throws Exception {
        return new ErrorResponder(e).makeResponse(this.context, request);
    }

    public static LogData makeLogData(Socket socket, Request request, Response response) {
        return new LogData(((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().getHostAddress(), new GregorianCalendar(), request.getRequestLine(), response.getStatus(), response.getContentSize(), request.getAuthorizationUsername());
    }

    public void log(Socket s, Request request, Response response) {
        if (this.context.logger != null) {
            this.context.logger.log(FitNesseExpediter.makeLogData(s, request, response));
        }
    }
}

