/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.FixtureClass;
import fit.FixtureName;
import fit.exception.CouldNotLoadComponentFitFailureException;
import fit.exception.NoSuchFixtureException;
import java.util.HashSet;
import java.util.Set;

public class FixtureLoader {
    private static FixtureLoader instance;
    public Set<String> fixturePathElements = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("fit");
        }
    };

    public static FixtureLoader instance() {
        if (instance == null) {
            instance = new FixtureLoader();
        }
        return instance;
    }

    public static void setInstance(FixtureLoader loader) {
        instance = loader;
    }

    public Fixture disgraceThenLoad(String tableName) throws Throwable {
        FixtureName fixtureName = new FixtureName(tableName);
        Fixture fixture = this.instantiateFirstValidFixtureClass(fixtureName);
        this.addPackageToFixturePath(fixture);
        return fixture;
    }

    private void addPackageToFixturePath(Fixture fixture) {
        Package fixturePackage = fixture.getClass().getPackage();
        if (fixturePackage != null) {
            this.addPackageToPath(fixturePackage.getName());
        }
    }

    public void addPackageToPath(String name) {
        this.fixturePathElements.add(name);
    }

    private Fixture instantiateFixture(String fixtureName) throws Throwable {
        Class<?> classForFixture = this.loadFixtureClass(fixtureName);
        FixtureClass fixtureClass = new FixtureClass(classForFixture);
        return fixtureClass.newInstance();
    }

    private Class<?> loadFixtureClass(String fixtureName) {
        try {
            return Class.forName(fixtureName);
        }
        catch (ClassNotFoundException deadEnd) {
            if (deadEnd.getMessage().equals(fixtureName)) {
                throw new NoSuchFixtureException(fixtureName);
            }
            throw new CouldNotLoadComponentFitFailureException(deadEnd.getMessage(), fixtureName);
        }
    }

    private Fixture instantiateFirstValidFixtureClass(FixtureName fixtureName) throws Throwable {
        for (String each : fixtureName.getPotentialFixtureClassNames(this.fixturePathElements)) {
            try {
                return this.instantiateFixture(each);
            }
            catch (NoSuchFixtureException noSuchFixtureException) {
            }
        }
        throw new NoSuchFixtureException(fixtureName.toString());
    }
}

