/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;

public class ColumnFixture
extends Fixture {
    protected Binding[] columnBindings;
    protected boolean executeCalledForRow = false;

    @Override
    public void doRows(Parse rows) {
        this.bindColumnHeadersToMethodsAndFields(rows.parts);
        super.doRows(rows.more);
    }

    @Override
    public void doRow(Parse row) {
        this.executeCalledForRow = false;
        try {
            this.reset();
            super.doRow(row);
            if (!this.executeCalledForRow) {
                this.execute();
            }
        }
        catch (Exception e) {
            this.exception(row.leaf(), e);
        }
    }

    @Override
    public void doCell(Parse cell, int column) {
        try {
            this.columnBindings[column].doCell(this, cell);
        }
        catch (Throwable e) {
            this.exception(cell, e);
        }
    }

    @Override
    public void check(Parse cell, TypeAdapter a) {
        try {
            this.executeIfNeeded();
        }
        catch (Exception e) {
            this.exception(cell, e);
        }
        super.check(cell, a);
    }

    protected void executeIfNeeded() throws Exception {
        if (!this.executeCalledForRow) {
            this.executeCalledForRow = true;
            this.execute();
        }
    }

    public void reset() throws Exception {
    }

    public void execute() throws Exception {
    }

    protected void bindColumnHeadersToMethodsAndFields(Parse heads) {
        try {
            this.columnBindings = new Binding[heads.size()];
            int i = 0;
            while (heads != null) {
                this.columnBindings[i] = this.createBinding(i, heads);
                ++i;
                heads = heads.more;
            }
        }
        catch (Throwable throwable) {
            this.exception(heads, throwable);
        }
    }

    protected Binding createBinding(int column, Parse heads) throws Throwable {
        return Binding.create(this, heads.text());
    }
}

